# localHashGNN
Experiment for the local hash idea for inference efficient GNN design

## Quick Start
Before our main algorithm, we need to train and save the target models. Please refer to "script/baseline_SAGE_test.ipynb" to run and generate the target model of SAGE as an example. We also include the code to generate the other SOTA models in "opt/AAAI25". We recommend to run through the example of SAGE models to understand the whole pipeline. 

After generating the target models, for a dataset DATA, simply run 

```
cd shell
bash launch_DATA.sh
```

to reproduce the main results for some datasets. Proper configuration of cpu and gpu ranges in the first few lines might be required to correctly assign the computation resource. Configure "model_name_pool" properly to only include the trained target models. 

## The File Sturectures and the description of the critical files
├── __config__    _Folder to the configs_\
├── __data_utils.py__    _Ultilities related to data processing_\
├── __graph_dict.py__    _Main library for the SDMP generation module_\
├── __main_gen_SDMP.py__    _Main entrance to the SDMP genration program_\
├── __main_test_SDMP.py__    _Main entrance to the downstream MLP test program_\
├── __model.py__    _Various models_\
├── __README.md__    _Read me files_\
├── __script__    _Folder to ipynb scripts for some one time code segments_\
│   ├── baseline_SAGE_test.ipynb    _SAGE baseline trainning_\
│   ├── SDMP.ipynb    _SDMP training, debugging and inference time test_\
├── __shell__    _Shell files to launch experiments_\
└── __utils.py__    _Various utilities_\
